<?php

//require all includes at the top

require_once( 'includes/actions.php' );
require_once( 'includes/filters.php' );

require_once( 'includes/theme-customizer.php' );

require_once( 'includes/scripts.php' );
require_once( 'includes/layout.actions.php' );

require_once( 'includes/lib/nav-walker.php');
require_once( 'includes/lib/class.mu-post-helper.php' );

require_once('includes/page-meta.php');
require_once('includes/services.post-type.php');

//insert magic below.

add_action('admin_menu', 'add_outage_menu');
add_action('admin_enqueue_scripts', 'enqueue_outage_scripts');
add_action('admin_print_styles', 'enqueue_outage_styles');

function enqueue_outage_styles() {
	wp_enqueue_style( 'jquery-ui-datepicker-style' , '//ajax.googleapis.com/ajax/libs/jqueryui/1.10.4/themes/smoothness/jquery-ui.css');
}

function enqueue_outage_scripts() {
	wp_enqueue_script('jquery-ui-datepicker');
}

function add_outage_menu() {
	add_options_page('Outage Notice', 'Outages', 'manage_options', 'outage-notices', 'outage_page');
}

function outage_page() {
	if($_SERVER['REQUEST_METHOD'] == 'POST') {
		$endDate = $_POST['_notice_end_date'] . ' ' . $_POST['_notice_end_hour'] . ':' . $_POST['_notice_end_min'] . ' ' . $_POST['_notice_end_ampm'];

		date_default_timezone_set('America/Detroit');

		set_transient( '_outage_notice', $_POST['_notice_message'], strtotime($endDate) - time() );
	}

	?>
	<form class="wrap" method="post">
		<h1>Outage Notice</h1>
		<p>Schedule outage notices to show above login buttons.</p>

		<table class="form-table">
			<tr>
				<th>Notice Message</th>
				<td>
					<input type="text" placeholder="Enter message to be displayed..." name="_notice_message" class="widefat" value="<?php echo get_transient('_outage_notice'); ?>">
				</td>
			</tr>

			<tr>
				<th>End Date</th>
				<td>
					<input type="text" placeholder="Select date..." id="ss_date" name="_notice_end_date">
					<select name="_notice_end_hour">
						<?php
						for($i = 1; $i <= 12; $i ++) {
							?>
							<option value="<?php echo $i; ?>"><?php echo $i; ?></option>
							<?php
						}
						?>
					</select>:
					<select name="_notice_end_min">
						<?php
						for($i = 0; $i <= 55; $i += 5) {
							if($i < 10) { $i = '0' . $i ; }
							?>
							<option value="<?php echo $i; ?>"><?php echo $i; ?></option>
							<?php
						}
						?>
					</select>
					<select name="_notice_end_ampm">
						<option value="am">AM</option>
						<option value="pm">PM</option>
					</select>
				</td>
			</tr>

			<tr>
				<td></td>
				<td>
					<button type="submit" class="button button-primary button-large">Save Notice</button>
				</td>
			</tr>
		</table>
	</form>

	<script>
	jQuery( function($) {
		$("#ss_date").datepicker();
	} );
	</script>
	<?php
}
add_action( 'wp_footer', 'mycustom_wp_footer' );

function mycustom_wp_footer() {
?>
<script type="text/javascript">
document.addEventListener( 'wpcf7mailsent', function( event ) {
    ga( 'send', 'event', 'Contact Form', 'submit' );
}, false );
</script>
<?php
}
