<?php

if ( !defined( 'ABSPATH' ) ) {
	exit();
}
	
if ( !class_exists( 'MU_Theme_Customizer' ) ) {
	
	/**
	 * Tie in to the Wordpress Customize API.
	 *
	 * @version 3.2
	 */
	class MU_Theme_Customizer{
		
		
		function __construct() {
			add_action( 'customize_register', array( $this ,'customize_register'), 10, 1 );
		}
		
		function customize_register( $wp_customize ){
			$this->add_slider_settings( $wp_customize );
			$this->add_social_settings( $wp_customize );
			$this->add_footer_settings( $wp_customize );
		}
		
		
		/**
		 * Social network settings.
		 *
		 * @since 1.0
		 *
		 * @link https://codex.wordpress.org/Theme_Customization_API
		 *
		 * @param  OBJ $wp_customize WP_Customizer object.
		 * @return void
		 */
		function add_social_settings( $wp_customize ){
			
			
			/* Filter to add support for more social networks, or remove them all together */
			$social = apply_filters( 
				'mindutopia_custom_social_network_support', 
				array( 
					'facebook'  => 'Facebook', 
					'twitter'   => 'Twitter', 
					'pinterest' => 'Pinterest',  
					'youtube'   => 'Youtube',  
					'instagram' => 'Instagram', 
					'googleplus' => 'Google +',  
				) 
			);
			
			if ( !empty( $social ) && is_array( $social ) ) {
				$wp_customize->add_section( 'social_settings' , array(
				    'title'      => __( 'Social Networks', 'mindutopia' ),
				    'priority'   => 30,
				) );
				
				foreach ( $social as $mod => $label ) {
					
					/* Filter for default value */
					$default = apply_filters( 'theme_mod_'.$mod, '' );
					$wp_customize->add_setting( $mod , array(
					    'default'     => $default,
					    'transport'   => 'refresh',
					) );
					$wp_customize->add_control(
					    new WP_Customize_Control(
					        $wp_customize,
					        $mod,
					        array(
					            'label'          => __( $label, 'mindutopia' ),
					            'section'        => 'social_settings',
					            'settings'       => $mod,
					            'type'           => 'text'
					        )
					    )
					);
				} // end for each.
			}
			
		}
		/**
		 * Slider settings.
		 *
		 * @since 1.0
		 *
		 * @link https://codex.wordpress.org/Theme_Customization_API
		 *
		 * @param  OBJ $wp_customize WP_Customizer object.
		 * @return void
		 */
		function add_slider_settings( $wp_customize ){
			$wp_customize->add_section( 'slider_settings' , array(
			    'title'      => __( 'Slider Settings', 'mindutopia' ),
			    'priority'   => 31,
			    'active_callback' => 'is_front_page',
			) );
			
			$wp_customize->add_setting( 'mind_slider_speed' , array(
			    'default'     => 4000,
			    'transport'   => 'refresh',
			) );

			$wp_customize->add_control(
			    new WP_Customize_Control(
			        $wp_customize,
			        'mind_slider_speed',
			        array(
			            'label'          => __( 'Speed', 'mindutopia' ),
			            'section'        => 'slider_settings',
			            'settings'       => 'mind_slider_speed',
			            'type'           => 'select',
			            'choices'        => array(
			                4000   => __( '4 Seconds' ),
			                5000   => __( '5 Seconds' ),
			                6000   => __( '6 Seconds' ),
			                7000   => __( '7 Seconds' ),
			                8000   => __( '8 Seconds' ),
			            )
			        )
			    )
			);
		}
		
		/**
		 * Footer settings.
		 *
		 * @since 1.0
		 *
		 * @link https://codex.wordpress.org/Theme_Customization_API
		 *
		 * @param  OBJ $wp_customize WP_Customizer object.
		 * @return void
		 */
		function add_footer_settings( $wp_customize ){
			$wp_customize->add_section( 'footer_settings' , array(
			    'title'      => __( 'Footer Settings', 'mindutopia' ),
			    'priority'   => 161,
			) );
			
			$wp_customize->add_setting( 'footer_copyright', array(
			    'default'     => '',
			    'transport'   => 'refresh',
			) );
			$wp_customize->add_setting( 'phone_number', array(
			    'default'     => '',
			    'transport'   => 'refresh',
			) );
			
			$wp_customize->add_setting( 'quote_link', array(
			    'default'     => '',
			    'transport'   => 'refresh',
			) );
			
			$wp_customize->add_setting( 'left_footer_image', array(
			    'default'     => '',
			    'transport'   => 'refresh',
			) );
			
			$wp_customize->add_setting( 'get_started_text', array(
			    'default'     => '',
			    'transport'   => 'refresh',
			) );
			
			$wp_customize->add_setting( 'footer_buttons', array(
			    'default'     => '',
			    'transport'   => 'refresh',
			) );
			
			$wp_customize->add_setting( 'email', array(
			    'default'     => '',
			    'transport'   => 'refresh',
			) );

			$wp_customize->add_control(
			    new WP_Customize_Control(
			        $wp_customize,
			        'footer_copyright',
			        array(
			            'label'          => __( 'Footer Copyright', 'mindutopia' ),
			            'section'        => 'footer_settings',
			            'settings'       => 'footer_copyright',
			            'type'           => 'textarea'    
			        )
			    )
			);
			
			$wp_customize->add_control(
			    new WP_Customize_Control(
			        $wp_customize,
			        'footer_buttons',
			        array(
			            'label'          => __( 'Login Button HTML', 'mindutopia' ),
			            'section'        => 'footer_settings',
			            'settings'       => 'footer_buttons',
			            'type'           => 'textarea'    
			        )
			    )
			);
			
			$wp_customize->add_control(
			    new WP_Customize_Control(
			        $wp_customize,
			        'get_started_text',
			        array(
			            'label'          => __( 'Get Started Text', 'mindutopia' ),
			            'section'        => 'footer_settings',
			            'settings'       => 'get_started_text',
			            'type'           => 'textarea'    
			        )
			    )
			);
			
			$wp_customize->add_control(
			    new WP_Customize_Control(
			        $wp_customize,
			        'phone_number',
			        array(
			            'label'          => __( 'Phone Number', 'mindutopia' ),
			            'section'        => 'footer_settings',
			            'settings'       => 'phone_number',
			            'type'           => 'text'    
			        )
			    )
			);
			
			$wp_customize->add_control(
			    new WP_Customize_Control(
			        $wp_customize,
			        'email',
			        array(
			            'label'          => __( 'Email Address', 'mindutopia' ),
			            'section'        => 'footer_settings',
			            'settings'       => 'email',
			            'type'           => 'text'    
			        )
			    )
			);
			
			$wp_customize->add_control(
			    new WP_Customize_Control(
			        $wp_customize,
			        'quote_link',
			        array(
			            'label'          => __( 'Quote Link', 'mindutopia' ),
			            'section'        => 'footer_settings',
			            'settings'       => 'quote_link',
			            'type'           => 'text'    
			        )
			    )
			);
			
			$wp_customize->add_control(
			    new WP_Customize_Image_Control(
			        $wp_customize,
			        'left_footer_image',
			        array(
			            'label'          => __( 'Left Background Image', 'mindutopia' ),
			            'section'        => 'footer_settings',
			            'settings'       => 'left_footer_image'    
			        )
			    )
			);
			
			/*$wp_customize->add_control(
			    new WP_Customize_Image_Control(
			        $wp_customize,
			        'right_footer_image',
			        array(
			            'label'          => __( 'Right Background Image', 'mindutopia' ),
			            'section'        => 'footer_settings',
			            'settings'       => 'right_footer_image'    
			        )
			    )
			);*/
		}
		
	}
	
	/* Initialize our theme customizer */
	function mu_init_customizer(){
		new MU_Theme_Customizer();
	}
	
	add_action( 'init', 'mu_init_customizer' );
}