

var _bsGrid = {
	'sm-max'	:	768,
	'md-max'	:	992,
	'lg-max'	:	1200
};

(function($) {  
    $.fn.extend({  
        isChildOf: function (filter) {  
            return $(filter).find(this).length > 0;  
        }  
    });  
})(jQuery); 

// Avoid `console` errors in browsers that lack a console.
(function() {
    var method;
    var noop = function () {};
    var methods = [
        'assert', 'clear', 'count', 'debug', 'dir', 'dirxml', 'error',
        'exception', 'group', 'groupCollapsed', 'groupEnd', 'info', 'log',
        'markTimeline', 'profile', 'profileEnd', 'table', 'time', 'timeEnd',
        'timeStamp', 'trace', 'warn'
    ];
    var length = methods.length;
    var console = (window.console = window.console || {});

    while (length--) {
        method = methods[length];

        // Only stub undefined methods.
        if (!console[method]) {
            console[method] = noop;
        }
    }
}());

var vidStatus = -1;

function onPlayerStateChange(e) {
	console.log(e);
	
	if(e.data == YT.PlayerState.PLAYING) {
		if(vidStatus == -1) {
			vidStatus = 0; //First start
			
			//log start
			__gaTracker('send', 'event', 'Video', 'play', videoTitle);
		}
	}
	else if(e.data == YT.PlayerState.ENDED) {
		if(vidStatus == 0) {
			//can log end
			__gaTracker('send', 'event', 'Video', 'ended', videoTitle);
		}
	}
}


jQuery(document).ready(function($){
	
	$('html').removeClass( 'no-js' );
	if( site_data != 'undefined' ){

		console.log( 'site_data is enabled and populated!' );
		console.log( site_data.ajax_url );
	}
	
	$(".navbar .navbar-togbtn").on('click', function(e) {
		e.preventDefault();
		$(".navbar").toggleClass('navbar-open');
	});
	
	$(".navbar .mobile-nav .menu-item.dropdown").on('click', function(e) {
		if(!$(this).hasClass("dropdown-open")) {
			e.preventDefault();
			$(this).addClass("dropdown-open");
		}
	});
	
	$(".date-462>input").datepicker({});
	
	if($("body").hasClass('page-become-a-mystery-shopper')) {
		//put content in scrollable box
		var content = $("article.page").children(':not(header,.intro)');
		var scrl = $("article.page").append('<div class="scrollagrwrap"><div class="scrollable-agreement"></div></div>');
		$(content).detach().appendTo(".scrollable-agreement");
		
		$(".scrollable-agreement").on('scroll', function() {
			if($(this).scrollTop() + $(this).innerHeight() >= ($(this)[0].scrollHeight - 60) ) {
				$(".signup").removeClass("disabled");
				$('.scrollagrwrap').addClass('bottom');
				$(this).off('scroll');
			}
		});
		
		$("article.page").append('<div class="text-center"><a href="https://www.sassieshop.com/sassie/SassieShopperSignup/Signup.php?EmsID=QHSjjKyrhOA%3D" class="btn btn-primary disabled signup" target="_blank">I Agree</a></div>');
		//$("article.page").remove(content);
	}
	
	$(".staff-item-click").on('click', function(e) {
		e.preventDefault();
		
		$.fancybox.open({
			type: 'ajax',
			href: site_data.ajax_url + "?action=staff_content&staff=" + $(this).attr('data-staff'),
			closeClick: false,
			maxWidth: 800,
			autoResize: true,
			fitToView: true,
			helpers: {
				overlay: {
					locked: false
    			}
    		}
		});
	});
	
	var loginForms = {
		'CLIENTS'		:	'<div class="form-group"><label>Company Name</label><input type="text" placeholder="Enter company name..." name="companyName"></div><div class="form-group"><label>Manager Login Name</label><input type="text" placeholder="Enter manager login name..." name="mgrLoginName"></div><div class="form-group"><label>Password</label><input type="password" placeholder="Enter password..." name="password"></div><a style="margin: 7px 0 0;" href="' + site_data.root_url + '/clients/" class="pull-left">Become a Client</a>',
		'SHOPPERS'		:	'<div class="form-group"><label>Email Address</label><input type="text" placeholder="Enter email address..." name="EmailH"></div><div class="form-group"><label>Password</label><input type="password" placeholder="Enter password..." name="password"></div><a style="margin: 7px 0 0;" href="' + site_data.root_url + '/shoppers/" class="pull-left">Become a Shopper</a>',
		'UNIVERSITY'	:	'<div class="form-group"><label>Login</label><input type="text" placeholder="Enter username..." name="UserName"></div><div class="form-group"><label>Password</label><input type="password" placeholder="Enter password..." name="Password"></div><input type="hidden" name="CustomLogOnPage" value="ShoppersViewUniversity">'
	};
	
	var shwnPopover;
	
	$(".login-btns a").on('click', function(e) {
		e.preventDefault();
		
		var frm = '<form action="' + $(this).attr('href') + '" method="POST" target="_blank">';
		frm += loginForms[ $(this).text().toUpperCase() ];
		frm += '<div class="form-group text-right"><button type="submit" class="btn btn-primary">Login &raquo;</button></div></form>';
		shwnPopover = $(this).popover({
			container:		'body',
			content:		frm,
			html:			true,
			placement:		'top',
			title:			'Login',
			trigger:		'manual'
		}).popover('show').one('shown.bs.popover', function() {
			$(".popover input").first().focus();
		});
		
		
	});
	
	$(document).on('mousedown', function(e) {
		if(shwnPopover) {
			if(!$(e.target).isChildOf(".popover") && e.target != $(".popover")) {
				//hide
				$(shwnPopover).popover("destroy");
				shwnPopover = false;
			}
		}
	});

	// Fixed Navigation bar after slider or whatever div you would like.
	function maybeFixed(action_break,target_mn){
        if( $(this).scrollTop() > $(action_break).height() ) {
            $(target_mn).addClass('navbar-fixed-top');
        } else {
             $(target_mn).removeClass('navbar-fixed-top');
        }
    }
    // maybeFixed('Space above target','the target');
    // $(window).scroll(function() {
    //     maybeFixed('.wrapper-container.header','.wrapper-container.navigation');
    // });

	//Fix contact page target
	//$("._form._inline-form").submit(function() {
		//$('._form._inline-form').prop( 'target', '_self' );
		//var tar = $('._form._inline-form').prop( 'target' );
		//console.log('submit '+tar);
	//});

});


/* Full Height Row JS */
var FullHeightRows = {
	init: function() {
		var $ = jQuery;
		this.DoLayout($);
		$(window).on('resize', this.DoLayout);
	},
	DoLayout: function() {
		var $ = jQuery;
		
		$(".full-height-row").each(function() {
			var row = $(this).parent();
			var mh = 1;
			$('>[class*="col-"]', row).each(function() {
				$(this).css('min-height', 1);
				if($(this).outerHeight() > mh) {
					mh = $(this).outerHeight();
				}
			});
			
			$('>[class*="col-"].full-height-row', row).each(function() {
				if($(this).attr('data-height-break') != undefined) {
					if(window.innerWidth >= _bsGrid[$(this).attr('data-height-break')]) {
						$(this).css('min-height', mh);
					}
					else {
						$(this).css('min-height', 1);
					}
				}
				else {
					$(this).css('min-height', mh);
				}
			});
		});
	}
};
